/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Localisation;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public final class Console
extends JFrame
implements ActionListener,
KeyListener,
MouseListener {
    private static final int NBHISTORYCMD = 1000;
    private static String EXEC;
    private static String CLOSE;
    private static String CLEAR;
    private static String DELETE;
    private static String HELP;
    private static String COPY;
    private static String DUMP;
    private Aladin aladin;
    private JTable table;
    private JTextArea fieldCmd;
    private JTextArea fieldPad;
    private JButton exec;
    private JButton clear;
    private JButton delete;
    private JButton dump;
    private JButton clearPad;
    private Vector<String> cmd;
    private Vector<Command> cmdHistory;
    private String currentCmd;
    private ArrayList<Lot> lots;
    private Lot currentLot;
    private static final int CMD = 0;
    private static final int INFO = 1;
    private static final int ERROR = 2;
    static final String[] TYPES;
    private static SimpleDateFormat SDF;
    private static final String HISTORYNAME = "History.ajs";
    static int LOT;
    private int indexArrowHistory;
    private static final int DATE = 0;
    private static final int TYPE = 1;
    private static final int DESC = 2;
    private int oIndexCmd;
    private int indexCmd;

    public void createChaine() {
        CLOSE = Aladin.chaine.getString("CLOSE");
        CLEAR = Aladin.chaine.getString("CLEAR");
        DELETE = Aladin.chaine.getString("RESETHISTORY");
        HELP = Aladin.chaine.getString("HELPSCRIPT");
        EXEC = Aladin.chaine.getString("EXEC");
        DUMP = Aladin.chaine.getString("NPCLONE");
    }

    public Console(Aladin aladin) {
        block4: {
            this.cmd = new Vector();
            this.cmdHistory = new Vector();
            this.currentCmd = null;
            this.lots = new ArrayList();
            this.currentLot = null;
            this.indexArrowHistory = -1;
            this.oIndexCmd = -1;
            this.indexCmd = -1;
            Aladin.setIcon(this);
            this.aladin = aladin;
            this.createChaine();
            this.setTitle(Aladin.chaine.getString("NPTITLE"));
            this.enableEvents(64L);
            Util.setCloseShortcut(this, false, aladin);
            this.addMouseListener(this);
            JPanel pane = (JPanel)this.getContentPane();
            pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            pane.add((Component)this.getHistoryPanel(), "North");
            JPanel p2 = new JPanel(new BorderLayout(5, 5));
            p2.add((Component)this.getCommandPanel(), "North");
            p2.add((Component)this.getPadPanel(), "Center");
            pane.add((Component)p2, "Center");
            if (Aladin.STANDALONE) {
                if (!Aladin.NOGUI) {
                    try {
                        this.loadHistory();
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace < 3) break block4;
                        e.printStackTrace();
                    }
                }
            }
        }
        this.pack();
        this.resumeButton();
    }

    public void printCommand(String cmd) {
        if (cmd == null || cmd.trim().length() == 0) {
            return;
        }
        if (!Localisation.notCoord(cmd)) {
            return;
        }
        this.cmdHistory.addElement(new Command(cmd));
        this.resetArrowHistory();
        this.resumeTable();
    }

    public void printInfo(String info) {
        this.cmdHistory.addElement(new Command(info, 1));
        this.resumeTable();
    }

    public void printError(String error) {
        this.cmdHistory.addElement(new Command(error, 2));
        this.resumeTable();
    }

    public void printInPad(String s) {
        boolean scroll = this.fieldPad.getCaretPosition() == this.fieldPad.getText().length();
        this.fieldPad.append(s);
        if (scroll) {
            this.fieldPad.setCaretPosition(this.fieldPad.getText().length());
        }
        this.clearPad.setEnabled(true);
    }

    public void dumpMeasurements() {
        this.printInPad(this.aladin.mesure.getText());
        this.aladin.log("DumpMeasurements", "");
    }

    public void clearPad() {
        this.fieldPad.setText("");
    }

    private void clear() {
        this.fieldCmd.setText("");
        this.resumeTable();
    }

    private void deleteHistory() {
        if (!Aladin.confirmation(this, Aladin.chaine.getString("NPCONF"))) {
            return;
        }
        this.cmdHistory.clear();
        this.resumeTable();
    }

    public synchronized void addLot(String s) {
        Lot lot = new Lot();
        String[] commands = Util.split(s, ";\n\r", '[', ']');
        for (int i = 0; i < commands.length; ++i) {
            lot.add(commands[i]);
        }
        this.lots.add(lot);
        this.aladin.command.readNow();
    }

    protected synchronized String pollLot() {
        String cmd = null;
        if (this.lots.size() == 0) {
            return null;
        }
        for (Lot lot : this.lots) {
            if (lot.isEmpty() || lot.waitingId == -2L) continue;
            if (lot.waitingId >= 0L) {
                boolean trouve = false;
                for (Thread th : Thread.getAllStackTraces().keySet()) {
                    if (th.getId() != lot.waitingId) continue;
                    trouve = true;
                    break;
                }
                if (trouve) continue;
                lot.waitingId = -1L;
            }
            if (lot.waitingId != -1L) continue;
            this.currentLot = lot;
            cmd = lot.poll();
            break;
        }
        ArrayList<Lot> lotsBis = new ArrayList<Lot>();
        for (Lot lot : this.lots) {
            if (lot.isEmpty()) continue;
            lotsBis.add(lot);
        }
        this.lots = lotsBis;
        return cmd;
    }

    public void memoThreadId(long threadId) {
        if (this.currentLot == null) {
            return;
        }
        this.currentLot.waitingId = threadId;
    }

    protected synchronized boolean hasWaitingLot() {
        if (this.lots.size() == 0) {
            return false;
        }
        for (Lot lot : this.lots) {
            if (lot.isEmpty() || lot.waitingId == -2L) continue;
            if (lot.waitingId >= 0L) {
                boolean trouve = false;
                for (Thread th : Thread.getAllStackTraces().keySet()) {
                    if (th.getId() != lot.waitingId) continue;
                    trouve = true;
                    break;
                }
                if (trouve) continue;
                return true;
            }
            if (lot.waitingId != -1L) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean hasWaitingCmd() {
        return this.cmd.size() > 0;
    }

    public synchronized void addCmd(String s) {
        String[] commands = Util.split(s, ";\n\r", '[', ']');
        for (int i = 0; i < commands.length; ++i) {
            this.cmd.addElement(commands[i]);
        }
        this.aladin.command.readNow();
    }

    public synchronized String pollCmd() {
        if (this.cmd.size() == 0) {
            return "";
        }
        String s = this.cmd.elementAt(0);
        this.cmd.removeElementAt(0);
        return s;
    }

    private void execute() {
        String cmd = this.fieldCmd.getText();
        if ((cmd = this.isCmdComplete(cmd)) != null) {
            this.addCmd(cmd);
            this.fieldCmd.setText("");
        }
    }

    @Override
    public void show() {
        super.show();
        this.fieldCmd.requestFocusInWindow();
    }

    private String isCmdComplete(String cmd) {
        if (!(cmd = cmd.trim()).startsWith("filter") && !cmd.startsWith("function")) {
            return cmd;
        }
        int n = cmd.length();
        int acc = 0;
        boolean findacc = false;
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = cmd.charAt(i);
            if (c == '{') {
                findacc = true;
                ++acc;
            } else if (c == '}') {
                --acc;
            }
            s.append(c);
        }
        if (acc == 0 || !findacc) {
            return s.toString();
        }
        return null;
    }

    public void saveHistory() throws Exception {
        String configDir = System.getProperty("user.home") + Util.FS + Aladin.CACHE;
        File f = new File(configDir);
        if (!f.isDirectory() && !f.mkdir()) {
            throw new Exception("Cannot create " + Aladin.CACHE + " directory");
        }
        String name = configDir + Util.FS + HISTORYNAME;
        f = new File(name);
        f.delete();
        int n = this.cmdHistory.size();
        Aladin.trace(2, "Saving command history [" + name + "]...");
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        if ((n -= 1000) < 0) {
            n = 0;
        }
        for (int i = n; i < this.cmdHistory.size(); ++i) {
            Command c = this.cmdHistory.elementAt(i);
            bw.write(c + "\n");
        }
        bw.close();
    }

    public void loadHistory() throws Exception {
        String s;
        String name = System.getProperty("user.home") + Util.FS + Aladin.CACHE + Util.FS + HISTORYNAME;
        File f = new File(name);
        if (!f.exists()) {
            return;
        }
        Aladin.trace(2, "Loading command history [" + name + "]...");
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((s = br.readLine()) != null) {
            if ((s = s.trim()).length() == 0) continue;
            Command c = new Command();
            if (s.charAt(0) == '#') {
                if (!c.setDate(s = s.substring(1))) {
                    c.cmd = s;
                    c.type = s.startsWith("!!!") ? 2 : 1;
                    this.cmdHistory.addElement(c);
                    continue;
                }
                s = br.readLine();
                if (s == null) break;
                if ((s = s.trim()).length() == 0) continue;
            }
            if (s.charAt(0) == '#') {
                s = s.substring(1);
                c.cmd = s;
                c.type = s.startsWith("!!!") ? 2 : 1;
            } else {
                c.cmd = s;
                c.type = 0;
            }
            if (c.type == 0 && !Localisation.notCoord(c.cmd)) continue;
            this.cmdHistory.addElement(c);
        }
    }

    private void resetArrowHistory() {
        this.indexArrowHistory = -1;
    }

    public int getIndexArrowHistory() {
        return this.indexArrowHistory;
    }

    public String getNextArrowHistory(int sens) {
        if (sens == 2) {
            this.resetArrowHistory();
        }
        if (this.indexArrowHistory == -1 && this.cmdHistory.size() > 0) {
            this.indexArrowHistory = this.cmdHistory.size();
        }
        Command cmd = null;
        try {
            this.indexArrowHistory += sens;
            while (!(this.indexArrowHistory < 0 && this.indexArrowHistory > this.cmdHistory.size() || (cmd = this.cmdHistory.get(this.indexArrowHistory)).isCmd() && !cmd.isFilter())) {
                this.indexArrowHistory += sens;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.indexArrowHistory < 0) {
            this.indexArrowHistory = 0;
        }
        if (this.indexArrowHistory >= this.cmdHistory.size()) {
            this.indexArrowHistory = -1;
        }
        if (this.indexArrowHistory == -1) {
            return null;
        }
        return cmd == null || !cmd.isCmd() ? null : cmd.getCommand();
    }

    public ArrayList<String> getRecentHistory(int max) {
        return this.getRecentHistory(0, max);
    }

    public ArrayList<String> getRecentHistory(int indexInit, int max) {
        int i;
        if (indexInit <= 0) {
            indexInit = 0;
        }
        ArrayList<String> v = new ArrayList<String>(max);
        int j = 0;
        for (i = this.cmdHistory.size() - 1; i >= 0 && v.size() < max; --i) {
            Command cmd = this.cmdHistory.get(i);
            if (!cmd.isCmd() || cmd.isFilter()) continue;
            if (j >= indexInit) {
                v.add(cmd.getCommand());
            }
            ++j;
        }
        if (i > 0) {
            v.set(max - 1, "...");
        }
        return v;
    }

    public void resumeButton() {
        try {
            this.dump.setEnabled(this.aladin.mesure.getNbSrc() > 0);
            this.clearPad.setEnabled(this.fieldPad.getText().trim().length() > 0);
            boolean qq = this.fieldCmd.getText().trim().length() > 0;
            this.clear.setEnabled(qq);
            this.exec.setEnabled(qq && this.isCmdComplete(this.fieldCmd.getText()) != null);
            this.delete.setEnabled(this.cmdHistory.size() > 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEnabledDumpButton(boolean flag) {
        this.dump.setEnabled(flag);
    }

    private void resumeTable() {
        while (this.cmdHistory.size() > 1000) {
            this.cmdHistory.removeElementAt(0);
        }
        ((HistoryTable)this.table.getModel()).fireTableDataChanged();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Console.this.table.scrollRectToVisible(Console.this.table.getCellRect(Console.this.cmdHistory.size() - 1, 0, true));
                Console.this.resumeButton();
            }
        });
    }

    private JPanel getCommandPanel() {
        JButton b;
        this.fieldCmd = new JTextArea(4, 60);
        JScrollPane sc = new JScrollPane(this.fieldCmd);
        this.fieldCmd.setFont(Aladin.COURIER);
        this.fieldCmd.addKeyListener(this);
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)new JLabel("Command:"), "North");
        p1.add((Component)sc, "South");
        JPanel p2 = new JPanel();
        this.exec = b = new JButton(EXEC);
        p2.add(b);
        b.addActionListener(this);
        b.setFont(b.getFont().deriveFont(1));
        this.clear = b = new JButton(CLEAR);
        p2.add(b);
        b.addActionListener(this);
        this.delete = b = new JButton(DELETE);
        p2.add(b);
        b.addActionListener(this);
        b = new JButton(HELP);
        p2.add(b);
        b.addActionListener(this);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)p1, "North");
        p.add((Component)p2, "South");
        return p;
    }

    private JPanel getPadPanel() {
        JButton b;
        this.fieldPad = new JTextArea(8, 60);
        JScrollPane sc = new JScrollPane(this.fieldPad);
        this.fieldPad.setFont(Aladin.COURIER);
        this.fieldPad.addKeyListener(this);
        JPanel p1 = new JPanel(new BorderLayout());
        p1.add((Component)new JLabel("Notepad:"), "North");
        p1.add((Component)sc, "Center");
        JPanel p2 = new JPanel();
        this.dump = b = new JButton(DUMP);
        p2.add(b);
        b.addActionListener(this);
        b.setEnabled(false);
        this.clearPad = b = new JButton(CLEAR);
        p2.add(b);
        b.addActionListener(this);
        b.setEnabled(false);
        p2.add(new JLabel("                 "));
        b = new JButton(CLOSE);
        p2.add(b);
        b.addActionListener(this);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)p1, "Center");
        p.add((Component)p2, "South");
        return p;
    }

    private JPanel getHistoryPanel() {
        JPanel p = new JPanel(new BorderLayout());
        JScrollPane sc = new JScrollPane(this.createHistoryTable());
        p.add((Component)sc, "Center");
        return p;
    }

    private JTable createHistoryTable() {
        this.table = new JTable(new HistoryTable());
        this.table.setSelectionMode(2);
        this.table.getColumnModel().getColumn(1).setMinWidth(40);
        this.table.getColumnModel().getColumn(1).setMaxWidth(40);
        this.table.getColumnModel().getColumn(0).setMinWidth(100);
        this.table.getColumnModel().getColumn(0).setMaxWidth(100);
        this.table.setPreferredScrollableViewportSize(new Dimension(420, 192));
        MyRenderer cr = new MyRenderer();
        this.table.getColumnModel().getColumn(1).setCellRenderer(cr);
        this.table.getColumnModel().getColumn(0).setCellRenderer(cr);
        this.table.getColumnModel().getColumn(2).setCellRenderer(cr);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Console.this.showSelectedCommands();
            }
        });
        return this.table;
    }

    private void showSelectedCommands() {
        int[] row = this.table.getSelectedRows();
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < row.length; ++i) {
            Command c = this.cmdHistory.elementAt(row[i]);
            if (c.type != 0) continue;
            s.append(c.cmd + "\n");
        }
        this.fieldCmd.setText(s.toString());
        if (row.length > 0) {
            this.setIndexCmd(row[0]);
        }
        this.resumeButton();
    }

    private void setIndexCmd(int n) {
        this.indexCmd = n;
    }

    private void showCmd(int sens) {
        String s;
        int index;
        if (sens == -1 && !this.isFirstLine()) {
            return;
        }
        if (sens == 1 && !this.isLastLine()) {
            return;
        }
        if (this.indexCmd == -1) {
            this.currentCmd = this.fieldCmd.getText();
        }
        int n = index = this.indexCmd == -1 ? this.cmdHistory.size() : this.indexCmd;
        if ((index += sens) < 0) {
            return;
        }
        this.indexCmd = index >= this.cmdHistory.size() ? -1 : index;
        if (this.oIndexCmd == this.indexCmd) {
            return;
        }
        this.oIndexCmd = this.indexCmd;
        if (this.indexCmd == -1) {
            s = this.currentCmd;
        } else {
            Command c = this.cmdHistory.elementAt(this.indexCmd);
            if (c.type != 0) {
                this.showCmd(sens);
                return;
            }
            s = c.getCommand();
        }
        this.fieldCmd.setText(s);
        if (this.indexCmd == -1) {
            this.table.getSelectionModel().clearSelection();
        } else {
            this.table.getSelectionModel().setSelectionInterval(this.indexCmd, this.indexCmd);
        }
        this.table.scrollRectToVisible(this.table.getCellRect(this.indexCmd == -1 ? this.cmdHistory.size() - 1 : this.indexCmd, 0, true));
    }

    private boolean isFirstLine() {
        int caret = this.fieldCmd.getCaretPosition();
        int pos = this.fieldCmd.getText().indexOf(10);
        return pos == -1 || caret < pos;
    }

    private boolean isLastLine() {
        int caret = this.fieldCmd.getCaretPosition();
        int pos = this.fieldCmd.getText().lastIndexOf(10);
        return pos == -1 || caret > pos;
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            this.fieldCmd.requestFocusInWindow();
            this.resumeTable();
            this.resumeButton();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 10) {
            this.execute();
        } else if (key == 38) {
            this.showCmd(-1);
        } else if (key == 40) {
            this.showCmd(1);
        } else {
            this.setIndexCmd(-1);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.resumeButton();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String what;
        Object src = evt.getSource();
        if (src == this.clearPad) {
            this.clearPad();
            return;
        }
        String string = what = src instanceof JButton ? ((JButton)src).getActionCommand() : "";
        if (CLOSE.equals(what)) {
            this.setVisible(false);
        } else if (CLEAR.equals(what)) {
            this.clear();
        } else if (DELETE.equals(what)) {
            this.deleteHistory();
        } else if (EXEC.equals(what)) {
            this.execute();
        } else if (DUMP.equals(what)) {
            this.dumpMeasurements();
        } else if (HELP.equals(what)) {
            this.aladin.command.execHelpCmd("", true);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.setVisible(false);
        }
        super.processWindowEvent(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.resumeButton();
    }

    static {
        TYPES = new String[]{"Cmd", "Info", "Error"};
        SDF = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        SDF.setTimeZone(TimeZone.getDefault());
        LOT = 0;
    }

    class Lot {
        int name = ++LOT;
        long waitingId = -1L;
        Queue<String> cmds = new LinkedList<String>();

        Lot() {
        }

        void add(String s) {
            this.cmds.add(s);
        }

        String poll() {
            String s = this.cmds.poll();
            return s;
        }

        boolean isEmpty() {
            return this.cmds.isEmpty();
        }
    }

    private class Command {
        private int type;
        private long date;
        private String cmd;

        private Command() {
        }

        private Command(String s) {
            this(s, 0);
        }

        private Command(String s, int t) {
            this.cmd = s;
            this.type = t;
            this.date = System.currentTimeMillis();
        }

        private String getType() {
            return TYPES[this.type];
        }

        private String getDate() {
            return this.date == 0L ? " ? " : SDF.format(this.date);
        }

        private String getCommand() {
            return this.cmd;
        }

        public boolean isCmd() {
            return this.type == 0;
        }

        public boolean isFilter() {
            return this.type == 0 && (this.cmd.trim().startsWith("filter") || this.date == 0L);
        }

        private boolean setDate(String s) {
            try {
                this.date = SDF.parse(s).getTime();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }

        public String toString() {
            String d = this.date == 0L ? "" : "#" + this.getDate() + "\n";
            return d + (this.type != 0 ? "#" : "") + this.getCommand();
        }
    }

    private class HistoryTable
    extends AbstractTableModel {
        private HistoryTable() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return Console.this.cmdHistory.size();
        }

        @Override
        public String getColumnName(int col) {
            return col == 1 ? "Type" : (col == 0 ? "Date" : "Description");
        }

        @Override
        public Object getValueAt(int row, int col) {
            Command c = (Command)Console.this.cmdHistory.elementAt(row);
            switch (col) {
                case 1: {
                    return c.getType();
                }
                case 0: {
                    return c.getDate();
                }
            }
            return c.getCommand();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2;
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            Command c = (Command)Console.this.cmdHistory.elementAt(row);
            Color color = Color.red;
            if (c.type == 0) {
                color = Color.black;
            } else if (c.type == 1) {
                color = Aladin.COLOR_GREEN;
            }
            cell.setForeground(color);
            cell.setFont(cell.getFont().deriveFont(col == 2 ? 1 : 0));
            return cell;
        }
    }
}

